--
-- TX78StarHV660
-- This is the specialization for TX78StarHV660s
-- It reacts both to steerable and attachable events
--
-- @author  Stefan Geiger
-- @date  04/12/08
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- @update for LS09 by SpeedySC1978
-- @date 05/12/09

TX78StarHV660 = {};

function TX78StarHV660.prerequisitesPresent(specializations)
    return true;
end;

function TX78StarHV660:load(xmlFile)

    self.setReelSpeed = SpecializationUtil.callSpecializationsFunction("setReelSpeed");
    self.onStartReel = SpecializationUtil.callSpecializationsFunction("onStartReel");
    self.onStopReel = SpecializationUtil.callSpecializationsFunction("onStopReel");
    self.isReelStarted = Cutter.isReelStarted;
    self.resetFruitType = SpecializationUtil.callSpecializationsFunction("resetFruitType");
    self.setFruitType = SpecializationUtil.callSpecializationsFunction("setFruitType");

    self.reelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reel#index"));

    self.rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
	
    self.schneckeMitte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeMitte"));
    self.haspelMitte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#haspelMitte"));	
	self.schneckeLinks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeLinks"));
	self.haspelLinks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#haspelLinks"));	
	self.schneckeRechts = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeRechts"));	
	self.haspelRechts = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#haspelRechts"));		

    local indexSpikesStr = getXMLString(xmlFile, "vehicle.reelspikes#index");
    self.spikesCount = getXMLInt(xmlFile, "vehicle.reelspikes#count");
    self.spikesRootNode = Utils.indexToObject(self.components, indexSpikesStr);

    self.sideArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#index"));
    self.sideArmMovable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sidearms#movable"), false);

    self.threshingParticleSystems = {};
    local psName = "vehicle.threshingParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, psName, self.components, false, nil, self.baseDirectory)
	
	local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;  
	local rotationPartNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight2#index"));
    if rotationPartNodeRight2 ~= nil then
        self.rotationPartRight2 = {};
        self.rotationPartRight2.node = rotationPartNodeRight2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#minRot"));
        self.rotationPartRight2.minRot = {};
        self.rotationPartRight2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#maxRot"));
        self.rotationPartRight2.maxRot = {};
        self.rotationPartRight2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#rotTime"), 2)*1000;
        self.rotationPartRight2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#touchRotLimit"), 10));
    end;
	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;    
	local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;

    self.fruitExtraObjects = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.fruitExtraObjects.fruitExtraObject(%d)", i);
        local t = getXMLString(xmlFile, key.."#fruitType");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            if self.currentExtraObject == nil then
                self.currentExtraObject = node;
                setVisibility(node, true);
            else
                setVisibility(node, false);
            end;
            self.fruitExtraObjects[t] = node;
        end;
        i = i +1;
    end;

    self.fruitTypes = {};
    self.fruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
    local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fruitTypes[desc.index] = true;
            end;
        end;
    end;

    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;

    self.reelStarted = false;
	
	self.CutterIsOpen = false;	

    self.forceLowSpeed = false;
    self.speedLimitLow = 12;
    self.speedLimit = 17.5;

    self.speedViolationMaxTime = 50;
    self.speedViolationTimer = self.speedViolationMaxTime;
    self.printRainWarning = false;


    self.lastArea = 0;

end;

function TX78StarHV660:delete()
end;

function TX78StarHV660:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TX78StarHV660:keyEvent(unicode, sym, modifier, isDown)
		if not Input.isKeyPressed(Input.KEY_x) and self.keystate_6 then
			self.keystate_x = false;
		end;
		
		if Input.isKeyPressed(Input.KEY_x) and not self.keystate_6 then
			self.keystate_x = true;
			self.CutterIsOpen = not self.CutterIsOpen;
		end;
		
		if isDown and sym == Input.KEY_x then	
			self.rotationMinLeft2 = not	self.rotationMinLeft2;	
			self.rotationMinRight2 = not self.rotationMinRight2;
		end;			
end;

function TX78StarHV660:update(dt)

	
	        if self.reelStarted then
	            rotate(self.schneckeMitte, 0.5, 0, 0);
	            rotate(self.haspelMitte, 0.1, 0, 0);				
	            rotate(self.schneckeLinks, 0.5, 0, 0);	
	            rotate(self.haspelLinks, 0.1, 0, 0);				
	            rotate(self.schneckeRechts, 0.5, 0, 0);
	            rotate(self.haspelRechts, 0.1, 0, 0);				
	        end;
			
	if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.CutterIsOpen);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;
	if self.rotationPartRight2 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight2.maxRot, self.rotationPartRight2.minRot, 3, self.rotationPartRight2.rotTime, dt, not self.CutterIsOpen);
        setRotation(self.rotationPartRight2.node, unpack(newRot));
    end;
    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.CutterIsOpen);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;
    if self.rotationPartLeft2 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.CutterIsOpen);
        setRotation(self.rotationPartLeft2.node, unpack(newRot));
    end;    
end;

function TX78StarHV660:draw()

    if not self.CutterIsOpen then
		g_currentMission:addExtraPrintText("Taste X: In Arbeitshaltung");
	else
		g_currentMission:addExtraPrintText("Taste X: In Transporthaltung");
	end;

    if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
        local str = "2";
        local keyStr = InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)
        if Cutter.getUseLowSpeedLimit(self) then
            str = "1";
            keyStr = InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL1)
        end;
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), str, keyStr), 0.07+0.022, 0.019+0.029);
    end;

    if self.printRainWarning then
        --g_currentMission:addWarning("Dreschen Sie nicht bei Regen oder Hagel", 0.018, 0.033);
        g_currentMission:addWarning(g_i18n:getText("Dont_do_threshing_during_rain_or_hail"), 0.018, 0.033);
    end;

end;

function TX78StarHV660:onDetach()
    if self.deactivateOnDetach then
        Cutter.onDeactivate(self);
    end;
	self.CutterIsOpen = false;	
end;

function TX78StarHV660:onLeave()
    if self.deactivateOnLeave then
        Cutter.onDeactivate(self);
    end;
end;

function TX78StarHV660:onDeactivate()
    self:onStopReel();
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function TX78StarHV660:setReelSpeed(speed)
    self.reelSpeed = speed;
end;

function TX78StarHV660:onStartReel()
    self.reelStarted = false;
	if self.CutterIsOpen then 
		self.reelStarted = true;
	end;	
end;

function TX78StarHV660:onStopReel()
    self.reelStarted = false;
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function TX78StarHV660:isReelStarted()
    return self.reelStarted;
end;

function TX78StarHV660:resetFruitType()
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastArea = 0;
end;

function TX78StarHV660:setFruitType(fruitType)
    if self.currentFruitType ~= fruitType then
        self.currentFruitType = fruitType;
        self.lastArea = 0;

        Cutter.updateExtraObjects(self)
    end;
end;

function TX78StarHV660.getUseLowSpeedLimit(self)
    if self.forceLowSpeed or (self.attacherVehicle ~= nil and self.preferedCombineSize > self.attacherVehicle.combineSize) then
        return true;
    end;
    return false;
end;

function TX78StarHV660.updateExtraObjects(self)
    if self.currentExtraObject ~= nil then
        setVisibility(self.currentExtraObject, false);
        self.currentExtraObject = nil;
    end;
    if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local name = FruitUtil.fruitIndexToDesc[self.currentFruitType].name;
        local extraObject = self.fruitExtraObjects[name];
        if extraObject ~= nil then
            setVisibility(extraObject, true);
            self.currentExtraObject = extraObject;
        end;
    end;
end;

function TX78StarHV660.allowThreshing(earlyWarning)
    if early ~= nil and early == true then
        if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    else
        if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    end;
    return false;
end;
